<?php declare(strict_types = 1);

namespace idoit\Module\SyneticsFlows\Automation;

use idoit\Module\SyneticsFlows\Automation\Action\ActionType\ActionType;
use idoit\Module\SyneticsFlows\Automation\Trigger\Condition\Condition;
use idoit\Module\SyneticsFlows\Automation\Trigger\TriggerType\TriggerType;
use idoit\Module\SyneticsFlows\Serialization\ArrayFormat;
use idoit\Module\SyneticsFlows\Serialization\ReadonlyFormat;
use idoit\Module\SyneticsFlows\Serialization\SerializableTrait;
use idoit\Module\SyneticsFlows\Validation\Required;
use JsonSerializable;

class Automation implements JsonSerializable
{
    use SerializableTrait;

    public function __construct(
        private string $id = '',
        #[Required]
        private ?string $name = '',
        private string $status = 'inactive',
        private ?string $description = '',
        #[Required('The trigger is required. Add a trigger to the flow.')]
        private ?TriggerType $trigger = null,
        #[Required]
        private ?Condition $condition = null,
        #[ArrayFormat(ActionType::class)]
        #[Required('The action is required. Add an action to the flow.')]
        private array $actions = [],
        #[ReadonlyFormat]
        private ?Execution $execution = null,
        private ?int $createdBy = null,
    )
    {
    }

    public function getId(): string
    {
        return $this->id;
    }

    public function getStatus(): string
    {
        return $this->status;
    }

    public function getName(): ?string
    {
        return $this->name;
    }

    public function getDescription(): ?string
    {
        return $this->description;
    }

    public function getTrigger(): ?TriggerType
    {
        return $this->trigger;
    }

    public function getCondition(): ?Condition
    {
        return $this->condition;
    }

    public function getActions(): array
    {
        return $this->actions;
    }

    public function getExecution(): ?Execution
    {
        return $this->execution;
    }

    /**
     * @return int|null
     */
    public function getCreatedBy(): ?int
    {
        return $this->createdBy;
    }

    /**
     * @param Execution|null $execution
     *
     * @return void
     */
    public function setExecution(?Execution $execution): void
    {
        $this->execution = $execution;
    }
}
