<?php declare(strict_types = 1);

namespace idoit\Module\SyneticsFlows\Automation\Trigger\Invocation;

class ButtonInvocation extends Invocation
{
    public const TYPE = 'button';

    public function __construct(private ?string $automationId, InvocationContext $context)
    {
        $this->context = $context;
    }

    public function getAutomationId(): ?string
    {
        return $this->automationId;
    }

    public function __toString(): string
    {
        return 'Click on the button';
    }
}