<?php declare(strict_types = 1);

namespace idoit\Module\SyneticsFlows\Automation\Trigger\InvocationMatcher;

use idoit\Module\SyneticsFlows\Automation\Trigger\Invocation\Invocation;
use idoit\Module\SyneticsFlows\Automation\Trigger\Invocation\ObjectRecycledInvocation;

class ObjectRecycledMatcher extends DaoMatcher
{
    public function supports(Invocation $invocation): bool
    {
        return $invocation instanceof ObjectRecycledInvocation;
    }

    protected function getExtraConditions(Invocation $invocation): array
    {
        if (!$invocation instanceof ObjectRecycledInvocation) {
            return [];
        }

        return [
            "JSON_EXTRACT(automation_trigger, \"$.type\") = 'object'",
            "JSON_EXTRACT(automation_trigger, \"$.objectEvent\") = 'restored'",
        ];
    }
}
