<?php declare(strict_types = 1);

namespace idoit\Module\SyneticsFlows\Automation\Trigger\TriggerType;

use idoit\Module\SyneticsFlows\Validation\Required;
use idoit\Module\SyneticsFlows\Validation\ValidationCallback;
use idoit\Module\SyneticsFlows\Validation\ValidationMessage;

class ButtonTriggerType extends TriggerType
{
    public function __construct(
        #[Required]
        private ?string $name,
        private ?array $objectIds = null,
        private ?array $objectTypes = null,
        private ?string $objectTypeSelection = null

    )
    {
    }

    public function getName(): ?string
    {
        return $this->name;
    }

    public function getObjectIds(): ?array
    {
        return $this->objectIds;
    }

    public function getObjectTypes(): ?array
    {
        return $this->objectTypes;
    }

    public function getObjectTypeSelection(): ?string
    {
        return $this->objectTypeSelection;
    }


    #[ValidationCallback]
    public function validate(array $path): array
    {
        $results = [];
        if ($this->objectTypeSelection == 'type' && empty($this->objectTypes)) {
            $results[] = new ValidationMessage([...$path, 'objectTypes'], 'This value is required.');
        }

        if ($this->objectTypeSelection == 'objects' && empty($this->objectIds)) {
            $results[] = new ValidationMessage([...$path, 'objectIds'], 'This value is required.');
        }
        return $results;
    }
}
