<?php declare(strict_types = 1);

namespace idoit\Module\SyneticsFlows\Automation\Trigger\TriggerType;

use idoit\Module\SyneticsFlows\Validation\ValidationCallback;
use idoit\Module\SyneticsFlows\Validation\ValidationMessage;

class CategoryAttributeTriggerType extends CategoryTriggerType
{
    public function __construct(
        private ?array $category = null,
        private ?array $propertyId = null,
        private ?string $selectionType = null,
    )
    {
    }

    public function getCategory(): ?array
    {
        return $this->category;
    }

    public function getPropertyId(): ?array
    {
        return $this->propertyId;
    }

    public function getSelectionType(): ?string
    {
        return $this->selectionType;
    }

    #[ValidationCallback]
    public function validate(array $path): array
    {
        $results = [];
        if ($this->selectionType == 'categories' && empty($this->category)) {
            $results[] = new ValidationMessage([...$path, 'category'], 'This value is required.');
        }
        if ($this->selectionType == 'attributes' && empty($this->propertyId)) {
            $results[] = new ValidationMessage([...$path, 'propertyId'], 'This value is required.');
        }
        return $results;
    }
}
