<?php declare(strict_types = 1);

namespace idoit\Module\SyneticsFlows\Automation\Trigger\TriggerType;

use idoit\Module\SyneticsFlows\Validation\ValidationCallback;
use idoit\Module\SyneticsFlows\Validation\ValidationMessage;

class EntryRankedTriggerType extends CategoryTriggerType
{
    public function __construct(private ?array $status, private ?array $category)
    {
    }

    public function getStatus(): ?array
    {
        return $this->status;
    }

    public function getCategory(): ?array
    {
        return $this->category;
    }

    #[ValidationCallback]
    public function validate(array $path): array
    {
        $errors = [];

        if (!$this->status || count($this->status) === 0) {
            $errors[] = new ValidationMessage([...$path, 'status'], 'This value is required.');
        }

        if (gettype($this->category) === 'array' && count($this->category) === 0) {
            $errors[] = new ValidationMessage([...$path, 'category'], 'This value is required.');
        }

        return $errors;
    }
}
