<?php declare(strict_types = 1);

namespace idoit\Module\SyneticsFlows\Dto\Criteria;

abstract class ArrayCriteria extends FieldCriteria
{
    protected const CONDITION_PATTERN = '';

    public function __construct(?string $field = null, protected array $value = [])
    {
        parent::__construct($field);
    }

    public function getValue(): array
    {
        return $this->value;
    }

    public function getConditionPattern(): string
    {
        return static::CONDITION_PATTERN;
    }
}
