<?php declare(strict_types = 1);

namespace idoit\Module\SyneticsFlows\Dto\Criteria;

use idoit\Module\SyneticsFlows\Dto\Criteria;
use idoit\Module\SyneticsFlows\Validation\Required;

abstract class FieldCriteria extends Criteria
{
    public function __construct(
        #[Required]
        protected ?string $field = null
    )
    {
    }

    /**
     * @return string|null
     */
    public function getField(): ?string
    {
        return $this->field;
    }
}
