<?php declare(strict_types = 1);

namespace idoit\Module\SyneticsFlows\Model\Dto;

use idoit\Module\SyneticsFlows\Serialization\SerializableTrait;
use JsonSerializable;

class ObjectType implements JsonSerializable
{
    use SerializableTrait;

    public function __construct(
        private string $id,
        private string $title,
        private ?string $icon,
        private ?string $typeConst,
    )
    {
    }

    public function getId(): string
    {
        return $this->id;
    }

    public function getTitle(): string
    {
        return $this->title;
    }

    public function getIcon(): ?string
    {
        return $this->icon;
    }

    public function getTypeConst(): ?string
    {
        return $this->typeConst;
    }
}
