<?php declare(strict_types = 1);

namespace idoit\Module\SyneticsFlows\Template;

use idoit\Module\SyneticsFlows\Model\AttributeDataDao;
use idoit\Module\SyneticsFlows\Model\Dto\AttributeData;
use idoit\Module\SyneticsFlows\Template\TemplateVariables\ObjectAccessTemplate;
use isys_component_template_language_manager;
use Twig\Extension\AbstractExtension;
use Twig\TwigFilter;
use Twig\TwigFunction;

class TemplateExtension extends AbstractExtension
{
    private ?AttributeDataDao $dao = null;

    public function getFilters()
    {
        return [
            new TwigFilter('object', [$this, 'createObjectTemplate', ['is_variadic' => true, 'arguments' => true, 'needs_context' => true]]),
            new TwigFilter('data', [$this, 'getData', ['is_variadic' => true]]),
            new TwigFilter('trans', [$this, 'translate', ['is_variadic' => true]]),
        ];
    }

    private function getDao(): AttributeDataDao
    {
        if (!$this->dao) {
            $this->dao = new AttributeDataDao(\isys_application::instance()->container->get('database'));
        }
        return $this->dao;
    }

    public function getNodeVisitors()
    {
        return [new DataVisitor()];
    }


    public function getFunctions()
    {
        return [
            new TwigFunction('object', [$this, 'createObjectTemplate']),
            new TwigFunction('data', [$this, 'getData']),
            new TwigFunction('trans', [$this, 'translate']),
        ];
    }

    public function getData($value, string $path = ''): ?AttributeData
    {
        if (!is_string($value) && !is_int($value)) {
            return null;
        }
        if (empty($path)) {
            return null;
        }
        return$this->getDao()->get($path, "$value");
    }

    public function translate($value): string
    {
        if (!is_string($value)) {
            $value = "$value";
        }
        $language = \isys_application::instance()->container->get('language');
        if (!$language instanceof isys_component_template_language_manager) {
            return $value;
        }
        return $language->get($value);
    }

    public function createObjectTemplate($object, array $rest = []): ?ObjectAccessTemplate
    {
        if (!is_string($object) && !is_int($object)) {
            return null;
        }
        return new ObjectAccessTemplate("$object");
    }
}