<?php declare(strict_types = 1);

namespace idoit\Module\SyneticsFlows\Template\TemplateVariables;

use DateTime;
use idoit\Module\SyneticsFlows\Automation\Trigger\Invocation\Invocation;
use idoit\Module\SyneticsFlows\Automation\Trigger\Invocation\ObjectContext;

class TemplateVariables
{
    public function __construct(private Invocation $invocation)
    {
    }

    public function getVariables(): array
    {
        $context = $this->invocation->getContext();
        $now = new DateTime();
        $variables = [
            'date' => $now->format('Y-m-d'),
            'datetime' => $now->format('H:i Y-m-d'),
            'time' => $now->format('H:i'),
            'invocation' => $this->invocation,
        ];
        if ($context) {
            $variables['user'] = new ObjectAccessTemplate($context->getUserId());
        }
        if ($context instanceof ObjectContext) {
            $variables['object'] = new ObjectAccessTemplate($context->getObjectId());
        }
        return $variables;
    }
}