<?php declare(strict_types = 1);

namespace idoit\Module\SyneticsFlows\Validation;

use Attribute;
use idoit\Component\Helper\ArrayHelper;

#[Attribute(Attribute::TARGET_PROPERTY)]
class OneOf extends Validator
{
    /**
     * @param string[] $values
     */
    public function __construct(private array $values)
    {
    }

    public function validate(mixed $value): array
    {
        if (!ArrayHelper::hasElement($this->values, $value)) {
            $values = join(', ', $this->values);
            return ['Value should be one of: ' . $values . '.'];
        }
        return [];
    }
}