<?php declare(strict_types = 1);

namespace idoit\Module\SyneticsFlows\Validation;

use Attribute;

#[Attribute(Attribute::TARGET_PROPERTY)]
class Required extends Validator
{
    public function __construct(private ?string $errorMessage = null)
    {
    }

    public function validate(mixed $value): array
    {
        if (is_string($value) && strlen($value) > 0) {
            return [];
        }
        
        if (empty($value)) {
            return [$this->errorMessage ?? 'This value is required.'];
        }
        return [];
    }
}
