<?php declare(strict_types = 1);

namespace idoit\Module\SyneticsFlows\Validation;

use idoit\Module\SyneticsFlows\Serialization\SerializableTrait;
use JsonSerializable;

class ValidationMessage implements JsonSerializable
{
    use SerializableTrait;

    public function __construct(private array $path, private string $message)
    {
    }

    public function getPath(): array
    {
        return $this->path;
    }

    public function getMessage(): string
    {
        return $this->message;
    }
}