<script type="application/javascript">
  (() => {
    const buttons = JSON.parse('[{$triggerButtons|json_encode|escape:"javascript"}]');
    const navbar = document.getElementById('navBar');
    const buttonsContainer = document.createElement('div');
    navbar.insertBefore(buttonsContainer, navbar.querySelector('div[style]'));
    if (!Array.isArray(buttons)) {
      return;
    }
    buttonsContainer.append(...buttons.map(({ trigger, automation }) => {
      const { name } = trigger;
      const button = document.createElement('button');
      button.textContent = name;
      button.type = 'button';
      button.id = automation.id;
      button.classList.add('btn', 'btn-secondary', 'mr10');
      button.onclick = e => {
        e.stopPropagation();
        e.preventDefault();

        fetch(`[{isys_application::instance()->www_path}]api/flows/automation/invoke/[{$smarty.get.objID|strip_tags|escape}]/${automation.id}`)
          .then(a => a.json())
            .then(res => {
                if (res.ids?.length) {
                    return idoit.Notify.info(`Started Flow ${automation.name}`)
                }
                throw new Error('Error');
            })
          .catch(() => idoit.Notify.error(`Couldn’t start ${automation.name}`));
      };
      return button;
    }));
  })();
</script>
