<?php declare(strict_types = 1);

namespace idoit\Module\SyneticsFlows\Automation\Action\ActionType;

use idoit\Module\SyneticsFlows\Serialization\Discriminator;
use idoit\Module\SyneticsFlows\Serialization\SerializableTrait;
use JsonSerializable;

#[Discriminator([
    'send-email' => SendEmailAction::class,
    'api-call' => ApiCallAction::class,
    'create-object' => CreateObjectAction::class,
    'change-object' => ChangeObjectAction::class,
    'call-command' => CallIdoitCommandAction::class,
    'rank-object' => RankObjectAction::class,
])]
class ActionType implements JsonSerializable
{
    use SerializableTrait;
}
