<?php declare(strict_types = 1);

namespace idoit\Module\SyneticsFlows\Automation\Action\ActionType\AuthType;

use idoit\Module\SyneticsFlows\Validation\Required;

class BasicAuthType extends AuthType
{
    public function __construct(
        #[Required]
        private ?string $username,
        #[Required]
        private ?string $password,
    )
    {
    }

    public function getUsername(): ?string
    {
        return $this->username;
    }

    public function getPassword(): ?string
    {
        return $this->password;
    }

    public function prepareHeaders(): array
    {
        return [
            'Authorization' => 'Basic ' . base64_encode($this->username . ':' . $this->password),
        ];
    }
}