<?php declare(strict_types = 1);

namespace idoit\Module\SyneticsFlows\Automation\Action\ActionType;

use idoit\Module\SyneticsFlows\Automation\Action\ActionType\CmdbChange\CategoryChange;
use idoit\Module\SyneticsFlows\Automation\Action\ActionType\CmdbChange\CmdbScope;
use idoit\Module\SyneticsFlows\Serialization\ArrayFormat;
use idoit\Module\SyneticsFlows\Validation\Required;

class ChangeObjectAction extends ActionType
{
    public function __construct(
        #[Required]
        private ?CmdbScope $scope = null,
        #[ArrayFormat(CategoryChange::class)]
        private array $changes = [],
    )
    {
    }

    public function getScope(): ?CmdbScope
    {
        return $this->scope;
    }

    /**
     * @return CategoryChange[]
     */
    public function getChanges(): array
    {
        return $this->changes;
    }
}
