<?php declare(strict_types = 1);

namespace idoit\Module\SyneticsFlows\Automation\Action\ActionType\CmdbChange;

use idoit\Module\SyneticsFlows\Serialization\ArrayFormat;
use idoit\Module\SyneticsFlows\Serialization\SerializableTrait;
use idoit\Module\SyneticsFlows\Validation\Required;
use JsonSerializable;

class CategoryChange implements JsonSerializable
{
    use SerializableTrait;

    public function __construct(
        #[Required]
        private ?string $categoryId = null,
        #[ArrayFormat(CmdbChange::class)]
        private array $changes = [],
    )
    {
    }

    public function getCategoryId(): ?string
    {
        return $this->categoryId;
    }

    /**
     * @return CmdbChange[]
     */
    public function getChanges(): array
    {
        return $this->changes;
    }
}