<?php declare(strict_types = 1);

namespace idoit\Module\SyneticsFlows\Automation\Action\ActionType\IdoitCommand\Command;

use idoit\Module\SyneticsFlows\Automation\Action\ActionType\IdoitCommand\IdoitCommand;
use Symfony\Component\Console\Command\Command;

class StaticConverter implements CommandConverter
{
    /**
     * @param IdoitCommand[] $commands
     */
    public function __construct(private array $commands = [])
    {
    }

    public function addCommand(IdoitCommand $command): self
    {
        $this->commands[] = $command;

        return $this;
    }

    public function convert(Command $command): ?IdoitCommand
    {
        foreach ($this->commands as $candidate) {
            if ($candidate->getName() === $command->getName()) {
                return $candidate;
            }
        }
        return null;
    }

    public function supports(Command $command): bool
    {
        foreach ($this->commands as $candidate) {
            if ($candidate->getName() === $command->getName()) {
                return true;
            }
        }
        return false;
    }
}