<?php declare(strict_types = 1);

namespace idoit\Module\SyneticsFlows\Automation\Action\ActionType\IdoitCommand\DataSource\JDisc;

use idoit\Module\SyneticsFlows\Automation\Action\ActionType\IdoitCommand\DataSource\DataSource;
use idoit\Module\SyneticsFlows\Automation\Action\ActionType\IdoitCommand\Option\SelectOptionValue;
use idoit\Module\JDisc\Console\Command\JDiscImportCommand;

class JDiscDetailedLoggingDataSource implements DataSource
{
    /**
     * @param array $parameters
     * @return SelectOptionValue[]
     */
    public function getValues(array $parameters): array
    {
        return [
            new SelectOptionValue(
                (string) JDiscImportCommand::LOW_LOG_LEVEL,
                'Low',
            ),
            new SelectOptionValue(
                (string) JDiscImportCommand::NORMAL_LOG_LEVEL,
                'Normal',
            ),
            new SelectOptionValue(
                (string) JDiscImportCommand::HIGH_LOG_LEVEL,
                'High',
            ),
        ];
    }
}