<?php declare(strict_types = 1);

namespace idoit\Module\SyneticsFlows\Automation\Action\ActionType\IdoitCommand\DataSource\JDisc;

use idoit\Module\SyneticsFlows\Automation\Action\ActionType\IdoitCommand\DataSource\DataSource;
use idoit\Module\SyneticsFlows\Automation\Action\ActionType\IdoitCommand\Option\SelectOptionValue;
use isys_jdisc_dao;

class JDiscProfileDataSource implements DataSource
{
    /**
     * @param isys_jdisc_dao $dao
     */
    public function __construct(private isys_jdisc_dao $dao)
    {
    }

    /**
     * @param array $parameters
     * @return array|SelectOptionValue[]
     */
    public function getValues(array $parameters): array
    {
        $servers = ['null'];
        if ($parameters['server']) {
            $servers[] = $parameters['server'];
        }
        $conditions = ['jdisc_server' => $servers];
        $values = array_map(
            fn (mixed $data) => new SelectOptionValue(
                "{$data['id']}",
                "{$data['id']}: {$data['title']}"
            ),
            $this->dao->get_profiles(null, $conditions),
        );

        return array_values($values);
    }
}