<?php declare(strict_types = 1);

namespace idoit\Module\SyneticsFlows\Automation\Action\ActionType\IdoitCommand\DataSource;

use idoit\Module\SyneticsFlows\Automation\Action\ActionType\IdoitCommand\Option\SelectOptionValue;
use isys_component_dao_result;
use isys_ldap_dao;

class LDAPServerDataSource implements DataSource
{
    /**
     * @param isys_ldap_dao $dao
     */
    public function __construct(private isys_ldap_dao $dao)
    {
    }

    /**
     * @param array $parameters
     * @return array|SelectOptionValue[]
     */
    public function getValues(array $parameters): array
    {
        $result = $this->dao->get_active_servers();
        if (!$result instanceof isys_component_dao_result) {
            return [];
        }
        $values = [];
        while ($row = $result->get_row()) {
            $values[] = new SelectOptionValue(
                "{$row['isys_ldap__id']}",
                "{$row['isys_ldap__id']}: {$row['isys_ldap__hostname']}"
            );
        }
        return array_values($values);
    }
}