<?php declare(strict_types = 1);

namespace idoit\Module\SyneticsFlows\Automation\Action\ActionType\IdoitCommand\DataSource\Notification;

use idoit\Module\SyneticsFlows\Automation\Action\ActionType\IdoitCommand\DataSource\DataSource;
use idoit\Module\SyneticsFlows\Automation\Action\ActionType\IdoitCommand\Option\SelectOptionValue;
use isys_component_template_language_manager;
use isys_notifications_dao;

class NotificationTypeDataSource implements DataSource
{
    /**
     * @param isys_notifications_dao $dao
     * @param isys_component_template_language_manager $language
     */
    public function __construct(
        private isys_notifications_dao $dao,
        private isys_component_template_language_manager $language
    )
    {
    }

    /**
     * @param array $parameters
     * @return array|SelectOptionValue[]
     * @throws \isys_exception_database
     */
    public function getValues(array $parameters): array
    {
        $values = array_map(
            fn (mixed $data) => new SelectOptionValue(
                "{$data['id']}",
                "{$data['id']}: {$this->language->get($data['title'])}"
            ),
            $this->dao->get_type(),
        );
        return array_values($values);
    }
}