<?php declare(strict_types = 1);

namespace idoit\Module\SyneticsFlows\Automation\Action\ActionType\IdoitCommand\DataSource;

use idoit\Module\SyneticsFlows\Automation\Action\ActionType\IdoitCommand\Option\SelectOptionValue;
use idoit\Module\SyneticsFlows\Model\Dto\ObjectType;
use idoit\Module\SyneticsFlows\Model\ObjectTypeDao;
use isys_exception_database;

class ObjectTypeDataSource implements DataSource
{
    /**
     * @param ObjectTypeDao $dao
     */
    public function __construct(private ObjectTypeDao $dao)
    {
    }

    /**
     * @param array $parameters
     * @return array|SelectOptionValue[]
     * @throws isys_exception_database
     */
    public function getValues(array $parameters): array
    {
        return array_map(
            fn (ObjectType $type) => new SelectOptionValue($type->getId(), $type->getTitle()),
            $this->dao->getData()
        );
    }
}