<?php declare(strict_types = 1);

namespace idoit\Module\SyneticsFlows\Automation\Action\ActionType\IdoitCommand\DataSource;

use idoit\Module\SyneticsFlows\Automation\Action\ActionType\IdoitCommand\Option\SelectOptionValue;
use isys_exception_database;
use isys_module_import_csv;

class ProfileDataSource implements DataSource
{
    /**
     * @param array $parameters
     * @return array|SelectOptionValue[]
     * @throws isys_exception_database
     */
    public function getValues(array $parameters): array
    {
        $profiles = isys_module_import_csv::get_profiles();

        $values = array_map(
            fn (array $profile) => new SelectOptionValue(
                $profile['id'],
                "{$profile['id']}: {$profile['title']}"
            ),
            $profiles
        );

        return array_values($values);
    }
}