<?php declare(strict_types = 1);

namespace idoit\Module\SyneticsFlows\Automation\Action\ActionType\IdoitCommand\DataSource;

use Exception;
use idoit\Module\SyneticsFlows\Automation\Action\ActionType\IdoitCommand\Option\SelectOptionValue;
use isys_component_dao_result;
use isys_report_dao;

class ReportDataSource implements DataSource
{
    /**
     * @param array $parameters
     * @return array|SelectOptionValue[]
     * @throws Exception
     */
    public function getValues(array $parameters): array
    {
        $dao = isys_report_dao::instance();
        $result = $dao->get_reports();

        if (!$result instanceof isys_component_dao_result) {
            return [];
        }

        $values = [];
        while ($row = $result->get_row()) {
            $values[] = new SelectOptionValue(
                "{$row['isys_report__id']}",
                "{$row['isys_report__id']}: {$row['isys_report__title']}"
            );
        }

        return $values;
    }
}