<?php declare(strict_types = 1);

namespace idoit\Module\SyneticsFlows\Automation\Action\ActionType\IdoitCommand\Option;

use Symfony\Component\Console\Command\Command;
use Symfony\Component\Console\Input\InputOption;

class CollectionOptionConverter implements OptionConverter
{
    /**
     * @param OptionConverter[] $converters
     */
    public function __construct(private array $converters)
    {
    }

    public function convert(Command $command, InputOption $option): ?IdoitCliOption
    {
        foreach ($this->converters as $converter) {
            if (!$converter->supports($command, $option)) {
                continue;
            }
            return $converter->convert($command, $option);
        }
        return null;
    }

    public function supports(Command $command, InputOption $option): bool
    {
        foreach ($this->converters as $converter) {
            if ($converter->supports($command, $option)) {
                return true;
            }
        }
        return false;
    }
}