<?php declare(strict_types = 1);

namespace idoit\Module\SyneticsFlows\Automation\Action\ActionType\IdoitCommand\Option\JDisc;

use idoit\Module\SyneticsFlows\Automation\Action\ActionType\IdoitCommand\Option\StringOption;
use idoit\Module\SyneticsFlows\Validation\Required;
use idoit\Module\SyneticsFlows\Validation\ValidationMessage;

class JDiscDeviceStringOption extends StringOption
{
    /**
     * @param mixed $value
     * @param array $parameters
     * @return array
     */
    public function validate(mixed $value, array $parameters): array
    {
        $errors = [];
        if ($value === '') {
            $errors[] = new ValidationMessage([$this->name], Required::DEFAULT_MESSAGE);
        }

        return $errors;
    }
}