<?php declare(strict_types = 1);

namespace idoit\Module\SyneticsFlows\Automation\Action\ActionType\IdoitCommand\Option;

use idoit\Module\SyneticsFlows\Serialization\SerializableTrait;
use JsonSerializable;

class SelectOptionValue implements JsonSerializable
{
    use SerializableTrait;

    public function __construct(private string $value, private string $label)
    {
    }

    public function getValue(): string
    {
        return $this->value;
    }

    public function getLabel(): string
    {
        return $this->label;
    }
}