<?php declare(strict_types = 1);

namespace idoit\Module\SyneticsFlows\Automation\Action\ActionType\IdoitCommand\Option;

use Symfony\Component\Console\Command\Command;
use Symfony\Component\Console\Input\InputOption;

class SkipConverter implements OptionConverter
{
    private const SKIP_OPTIONS = [
        'user',
        'password',
        'tenantId',
        'config',
    ];

    /**
     * @var array<string, string[]>
     */
    private array $skipCommandOptions = [
        'extend-contracts' => ['simulate'],
        'search-index' => ['dry-run'],
        'ldap-sync' => ['dumpConfig'],
        'ldap-syncdn' => [
            'dnString',
            'dnType',
            'objectType',
        ],
        'import-csv' => [
            'csvSeparator',
            'multiValueMode',
            'multi-value-update-mode',
            'default-template',
            'headers',
            'empty-values',
        ],
        'jdisc:import' => ['listProfiles', 'ipFilter'],
        'import-jdisc' => ['listProfiles', 'ipFilter'],
        'import-xml' => ['usage'],
        'import-hinventory' => ['usage'],
    ];

    public function skipOption(string $command, string $option): self
    {
        if (!isset($this->skipCommandOptions[$command])) {
            $this->skipCommandOptions[$command] = [];
        }
        $this->skipCommandOptions[$command][] = $option;

        return $this;
    }

    public function convert(Command $command, InputOption $option): ?IdoitCliOption
    {
        return null;
    }

    public function supports(Command $command, InputOption $option): bool
    {
        if (isset($this->skipCommandOptions[$command->getName()])) {
            if (in_array($option->getName(), $this->skipCommandOptions[$command->getName()], true)) {
                return true;
            }
        }
        return in_array($option->getName(), self::SKIP_OPTIONS, true);
    }
}
