<?php declare(strict_types = 1);

namespace idoit\Module\SyneticsFlows\Automation\Action\ActionType\IdoitCommand\Option;

use idoit\Module\SyneticsFlows\Serialization\ArrayFormat;

class StringSelectOption extends IdoitCliOption implements ValueProviderOption
{
    /**
     * @param string $name
     * @param string $description
     * @param bool $required
     * @param SelectOptionValue[] $values
     * @param string|null $defaultValue
     */
    public function __construct(
        string $name,
        string $description,
        bool $required,
        #[ArrayFormat(SelectOptionValue::class)]
        private array $values,
        private ?string $defaultValue,
    )
    {
        parent::__construct($name, $description, $required);
    }

    /**
     * @return SelectOptionValue[]
     */
    public function getValues(array $parameters): array
    {
        return $this->values;
    }

    public function getDefaultValue(): ?string
    {
        return $this->defaultValue;
    }
}