<?php declare(strict_types = 1);

namespace idoit\Module\SyneticsFlows\Automation\Action\ActionType\IdoitCommand\Option\SyncDynamicGroups;

use idoit\Module\SyneticsFlows\Automation\Action\ActionType\IdoitCommand\Option\DynamicStringMultiSelectOption;
use idoit\Module\SyneticsFlows\Validation\Required;
use idoit\Module\SyneticsFlows\Validation\ValidationMessage;

class SyncDynamicGroupsOption extends DynamicStringMultiSelectOption
{
    /**
     * @param mixed $value
     * @param array $parameters
     * @return array
     */
    public function validate(mixed $value, array $parameters): array
    {
        if (isset($parameters['groups']) && empty($parameters['groups'])) {
            return [new ValidationMessage([$this->name], Required::DEFAULT_MESSAGE)];
        }

        if (!empty($parameters['groups']) && $parameters['groups'] === ['all']) {
            return [];
        }

        return parent::validate($value, $parameters);
    }
}