<?php declare(strict_types = 1);

namespace idoit\Module\SyneticsFlows\Automation\Action\ExecutionFactory;

use idoit\Module\SyneticsFlows\Automation\Action\ActionType\ActionType;
use idoit\Module\SyneticsFlows\Automation\Action\ActionType\CallIdoitCommandAction;
use idoit\Module\SyneticsFlows\Automation\Action\ExecutionInfo\CallIdoitCommandInfo;
use idoit\Module\SyneticsFlows\Automation\Action\ExecutionInfo\ExecutionInfo;
use idoit\Module\SyneticsFlows\Automation\Automation;
use idoit\Module\SyneticsFlows\Automation\Trigger\Invocation\Invocation;

class CallIdoitCommandFactory implements ExecutionFactory
{
    public function createExecution(Invocation $invocation, Automation $automation, ActionType $actionType): ?ExecutionInfo
    {
        if (!$actionType instanceof CallIdoitCommandAction) {
            return null;
        }

        return new CallIdoitCommandInfo($actionType->getCommand(), $actionType->getParameters());
    }

    public function supports(ActionType $actionType): bool
    {
        return $actionType instanceof CallIdoitCommandAction;
    }
}