<?php declare(strict_types = 1);

namespace idoit\Module\SyneticsFlows\Automation\Action\ExecutionFactory;

use idoit\Module\SyneticsFlows\Automation\Action\ActionType\ActionType;
use idoit\Module\SyneticsFlows\Automation\Action\ActionType\CreateObjectAction;
use idoit\Module\SyneticsFlows\Automation\Action\ExecutionInfo\CreateObjectInfo;
use idoit\Module\SyneticsFlows\Automation\Action\ExecutionInfo\ExecutionInfo;
use idoit\Module\SyneticsFlows\Automation\Automation;
use idoit\Module\SyneticsFlows\Automation\Trigger\Invocation\Invocation;
use idoit\Module\SyneticsFlows\Template\TemplateFactory;

class CreateObjectFactory implements ExecutionFactory
{
    public function __construct(private TemplateFactory $factory, private ProcessCategoryChanges $processCategoryChanges)
    {
    }

    public function createExecution(Invocation $invocation, Automation $automation, ActionType $actionType): ?ExecutionInfo
    {
        if (!$actionType instanceof CreateObjectAction) {
            return null;
        }
        $template = $this->factory->forInvocation($invocation, $automation);
        $objectTitle = $template->process($actionType->getTitle());
        $changes = $this->processCategoryChanges->process($template, $actionType->getChanges());

        return new CreateObjectInfo((int)$actionType->getObjectType(), $objectTitle, $changes);
    }

    public function supports(ActionType $actionType): bool
    {
        return $actionType instanceof CreateObjectAction;
    }
}
