<?php declare(strict_types = 1);

namespace idoit\Module\SyneticsFlows\Automation\Action\ExecutionFactory;

use idoit\Module\SyneticsFlows\Automation\Action\ActionType\ActionType;
use idoit\Module\SyneticsFlows\Automation\Action\ExecutionInfo\ExecutionInfo;
use idoit\Module\SyneticsFlows\Automation\Action\ExecutionInfo\PlannedExecutionInfo;
use idoit\Module\SyneticsFlows\Automation\Automation;
use idoit\Module\SyneticsFlows\Automation\Trigger\Invocation\Invocation;
use idoit\Module\SyneticsFlows\Automation\Trigger\Invocation\TimeInvocation;

class PlanExecutionFactory implements ExecutionFactory
{
    public function createExecution(Invocation $invocation, Automation $automation, ActionType $actionType): ?ExecutionInfo
    {
        if (!$invocation instanceof TimeInvocation) {
            return null;
        }

        return new PlannedExecutionInfo($actionType);
    }

    public function supports(ActionType $actionType): bool
    {
        return true;
    }
}