<?php declare(strict_types = 1);

namespace idoit\Module\SyneticsFlows\Automation\Action\ExecutionInfo;

use idoit\Module\SyneticsFlows\Validation\Required;

class CallIdoitCommandInfo extends ExecutionInfo
{
    public function __construct(
        #[Required]
        private ?string $command = null,
        private ?array $parameters = [],
    )
    {
    }

    public function getCommand(): ?string
    {
        return $this->command;
    }

    public function getParameters(): ?array
    {
        return $this->parameters;
    }

    public function __toString(): string
    {
        return 'Call i-doit command "' . $this->command . '"';
    }
}