<?php declare(strict_types = 1);

namespace idoit\Module\SyneticsFlows\Automation\Action\ExecutionResult;

use idoit\Module\SyneticsFlows\Validation\Required;

class ErrorExecutionResult extends ExecutionResult implements ErrorExecutionInterface
{
    public function __construct(
        #[Required]
        private ?string $message = null,
    )
    {
    }

    public function getMessage(): ?string
    {
        return $this->message;
    }

    public function __toString(): string
    {
        return 'Error: ' . $this->message;
    }
}
