<?php declare(strict_types = 1);

namespace idoit\Module\SyneticsFlows\Automation\Action\ExecutionResult;

use idoit\Module\SyneticsFlows\Validation\Required;

class ObjectCreatedResult extends ExecutionResult
{
    public function __construct(
        #[Required]
        private ?string $objectId = null,
        #[Required]
        private ?string $objectTitle = null
    )
    {
    }

    public function getObjectId(): ?string
    {
        return $this->objectId;
    }

    public function getObjectTitle(): ?string
    {
        return $this->objectTitle;
    }

    public function __toString(): string
    {
        return "Object {$this->objectTitle} ({$this->objectId}) created";
    }
}
