<?php declare(strict_types = 1);

namespace idoit\Module\SyneticsFlows\Automation\Action\ExecutionResult;

use idoit\Module\SyneticsFlows\Serialization\SerializableTrait;
use JsonSerializable;

class ValidationError implements JsonSerializable
{
    use SerializableTrait;

    public function __construct(
        private ?string $category = null,
        private ?string $field = null,
        private ?string $message = null,
        private ?string $objectId = null,
    )
    {
    }

    public function getCategory(): ?string
    {
        return $this->category;
    }

    public function getField(): ?string
    {
        return $this->field;
    }

    public function getMessage(): ?string
    {
        return $this->message;
    }

    public function getObjectId(): ?string
    {
        return $this->objectId;
    }
}