<?php declare(strict_types = 1);

namespace idoit\Module\SyneticsFlows\Automation\Trigger\Condition;

use idoit\Module\SyneticsFlows\Serialization\SerializableTrait;
use idoit\Module\SyneticsFlows\Validation\Required;
use idoit\Module\SyneticsFlows\Validation\ValidationCallback;
use idoit\Module\SyneticsFlows\Validation\ValidationMessage;
use JsonSerializable;

class TimeConditionRange implements JsonSerializable
{
    use SerializableTrait;

    public function __construct(
        #[Required]
        private ?string $weekday,
        #[Required]
        private ?string $startTime,
        #[Required]
        private ?string $endTime
    )
    {
    }

    public function getWeekday(): ?string
    {
        return $this->weekday;
    }

    public function getStartTime(): ?string
    {
        return $this->startTime;
    }

    public function getEndTime(): ?string
    {
        return $this->endTime;
    }

    #[ValidationCallback]
    public function validate(array $path): array
    {
        $results = [];

        if ($this->getStartTime() && $this->getEndTime() && $this->getStartTime() > $this->getEndTime()) {
            $results[] = new ValidationMessage([...$path, 'startTime'], 'LC__MODULE__SYNETICS_FLOWS__FROM_BEFORE_TO_TIME');
            $results[] = new ValidationMessage([...$path, 'endTime'], 'LC__MODULE__SYNETICS_FLOWS__TO_AFTER_FROM_TIME');
        }

        return $results;
    }
}
