<?php declare(strict_types = 1);

namespace idoit\Module\SyneticsFlows\Automation\Trigger\Condition;

use idoit\Module\SyneticsFlows\Validation\Required;

class UserCondition extends Condition
{
    public function __construct(
        #[Required]
        private ?array $usersAndUserGroupsIds = null,
    )
    {
    }

    public function getUserIds(): ?array
    {
        return $this->usersAndUserGroupsIds;
    }

}