<?php declare(strict_types = 1);

namespace idoit\Module\SyneticsFlows\Automation\Trigger\Invocation;

class CategoryCreatedInvocation extends Invocation
{
    public const TYPE = 'category-created';

    public function __construct(private string $category, ObjectContext $context)
    {
        $this->context = $context;
    }

    public function getCategory(): string
    {
        return $this->category;
    }

    public function __toString(): string
    {
        return 'Category is created';
    }
}