<?php declare(strict_types = 1);

namespace idoit\Module\SyneticsFlows\Automation\Trigger\Invocation;

use idoit\Module\SyneticsFlows\Serialization\Discriminator;
use idoit\Module\SyneticsFlows\Serialization\SerializableTrait;
use JsonSerializable;

#[Discriminator([
    ButtonInvocation::TYPE => ButtonInvocation::class,
    TimeInvocation::TYPE => TimeInvocation::class,
    ObjectCreatedInvocation::TYPE => ObjectCreatedInvocation::class,
    ObjectUpdatedInvocation::TYPE => ObjectUpdatedInvocation::class,
    ObjectRankedInvocation::TYPE => ObjectRankedInvocation::class,
    ObjectRecycledInvocation::TYPE => ObjectRecycledInvocation::class,
    ObjectPurgedInvocation::TYPE => ObjectPurgedInvocation::class,
    CategoryEntryRankedInvocation::TYPE => CategoryEntryRankedInvocation::class,
    CategoryCreatedInvocation::TYPE => CategoryCreatedInvocation::class,
    CategoryUpdatedInvocation::TYPE => CategoryUpdatedInvocation::class,
])]
abstract class Invocation implements JsonSerializable
{
    use SerializableTrait;

    const TYPE = '';

    protected ?InvocationContext $context = null;

    public function getContext(): ?InvocationContext
    {
        return $this->context;
    }

    public function setContext(?InvocationContext $context): void
    {
        $this->context = $context;
    }

    public function getType(): string
    {
        return static::TYPE;
    }

    public abstract function __toString(): string;
}
