<?php declare(strict_types = 1);

namespace idoit\Module\SyneticsFlows\Automation\Trigger\TriggerType;

use idoit\Module\SyneticsFlows\Validation\Required;
use idoit\Module\SyneticsFlows\Validation\ValidationCallback;
use idoit\Module\SyneticsFlows\Validation\ValidationMessage;

class ButtonTriggerType extends TriggerType
{
    public function __construct(
        #[Required]
        private ?string $name,
        private ?array $objectIds = null,
        private ?array $objectTypes = null,
        private ?string $objectTypeSelection = null,
        private ?string $icon = null,
        private ?array $category = null,
        #[StringArrayFormat]
        private ?array $group = [],
    )
    {
    }

    public function getName(): ?string
    {
        return $this->name;
    }

    public function getObjectIds(): ?array
    {
        return $this->objectIds;
    }

    public function getObjectTypes(): ?array
    {
        return $this->objectTypes;
    }

    public function getObjectTypeSelection(): ?string
    {
        return $this->objectTypeSelection;
    }

    public function getIcon(): ?string
    {
        return $this->icon;
    }

    public function getCategory(): ?array
    {
        return $this->category;
    }

    public function getGroup(): ?array
    {
        return $this->group;
    }

    #[ValidationCallback]
    public function validate(array $path): array
    {
        $results = [];
        if ($this->objectTypeSelection == 'type' && empty($this->objectTypes)) {
            $results[] = new ValidationMessage([...$path, 'objectTypes'], 'LC__MODULE__SYNETICS_FLOWS__VALUE_REQUIRED');
        }

        if ($this->objectTypeSelection == 'objects' && empty($this->objectIds)) {
            $results[] = new ValidationMessage([...$path, 'objectIds'], 'LC__MODULE__SYNETICS_FLOWS__VALUE_REQUIRED');
        }

        if (is_array($this->category) && count($this->category) === 0) {
            $results[] = new ValidationMessage([...$path, 'category'], 'This value is required.');
        }

        return $results;
    }
}
