<?php declare(strict_types = 1);

namespace idoit\Module\SyneticsFlows\Automation\Trigger\TriggerType\Repetition;

use DateInterval;
use DateTimeImmutable;
use Exception;

class YearRepetition extends Repetition
{
    /**
     * @param DateTimeImmutable $start
     * @param DateTimeImmutable $offset
     *
     * @return int
     */
    protected function getIterationNumber(DateTimeImmutable $start, DateTimeImmutable $offset): int
    {
        if ($offset <= $start) {
            return -1;
        }
        $diff = $offset->diff($start);
        return (int) ($diff->y / $this->period);
    }

    /**
     * @param DateTimeImmutable $start
     * @param int $iteration
     *
     * @return DateTimeImmutable[]
     *
     * @throws Exception
     */
    protected function getNextIterationDates(DateTimeImmutable $start, int $iteration): array
    {
        $count = ($iteration + 1) * $this->period;
        $date = $start->add(new DateInterval('P' . $count . 'Y'));

        return [$date];
    }
}
