<?php declare(strict_types = 1);

namespace idoit\Module\SyneticsFlows\ConnectSignal;

use idoit\Context\Context;
use idoit\Module\SyneticsFlows\Automation\Trigger\Invocation\ObjectContext;
use idoit\Module\SyneticsFlows\Automation\Trigger\Invocation\ObjectPurgedInvocation;
use idoit\Module\SyneticsFlows\Automation\Trigger\Invocation\ObjectRankedInvocation;
use idoit\Module\SyneticsFlows\Automation\TriggerService;
use isys_cmdb_dao;

class ObjectPurgedConnect
{
    private static function getContextCustomers()
    {
        return [
            Context::CONTEXT_RANK_OBJECT_PURGED,
        ];
    }

    public function __construct(private TriggerService $service)
    {
    }

    public function __invoke(string $type, int $objectId, string $objectTitle, int $objectType): void
    {
        if (!Connect::supportsContext(self::getContextCustomers())) {
            return;
        }

        $this->service->invoke(
            new ObjectPurgedInvocation(
                $objectTitle,
                new ObjectContext("$objectId", "$objectType")
            )
        );
    }
}
