<?php

namespace idoit\Module\SyneticsFlows\Controller;

use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\HttpFoundation\Response;

/**
 * JSONResponseFactory
 *
 * @package   idoit\Module\synetics_flows\Controller
 * @copyright synetics
 * @license   https://www.i-doit.com/
 */
class JSONResponseFactory
{
    private const ACCESS_DENIED = "You don’t have the permission to access this URL. Contact your administrator to request extended permissions. (Code: 403)";

    public static function error(string $error)
    {
        return new JsonResponse([
            'type' => 'error',
            'error' => $error
        ], Response::HTTP_BAD_REQUEST);
    }

    public static function serverError(string $error)
    {
        return new JsonResponse([
            'type'=> 'server-error',
            'error' => $error
        ], Response::HTTP_INTERNAL_SERVER_ERROR);
    }

    public static function successWithData(array $data)
    {
        return new JsonResponse($data, Response::HTTP_OK);
    }

    public static function success()
    {
        return new JsonResponse(['success' => true], Response::HTTP_OK);
    }

    public static function accessDenied(string $message = self::ACCESS_DENIED)
    {
        return new JsonResponse([
            'type' => 'access-denied',
            'error' => $message,
        ], Response::HTTP_FORBIDDEN);
    }
}
