<?php declare(strict_types = 1);

namespace idoit\Module\SyneticsFlows\Controller\Response;

use idoit\Module\SyneticsFlows\Serialization\SerializableTrait;
use JsonSerializable;

class ArrayResult implements JsonSerializable
{
    use SerializableTrait;

    protected int $perPage;

    public function __construct(
        protected array $results,
        protected ?int $total
    )
    {
        $this->perPage = count($this->results);
    }

    public function getResults(): array
    {
        return $this->results;
    }

    public function getPerPage(): int
    {
        return $this->perPage;
    }

    public function getTotal(): ?int
    {
        return $this->total;
    }
}