<?php declare(strict_types = 1);

namespace idoit\Module\SyneticsFlows;

use Symfony\Component\Config\FileLocator;
use Symfony\Component\DependencyInjection\ContainerBuilder;
use Symfony\Component\DependencyInjection\Extension\Extension;
use Symfony\Component\DependencyInjection\Loader\YamlFileLoader;
use Symfony\Component\DependencyInjection\Reference;

class FlowsExtension extends Extension
{
    public function load(array $configs, ContainerBuilder $container)
    {
        $fileLoader = new YamlFileLoader($container, new FileLocator(\isys_module_synetics_flows::getPath()));
        $fileLoader->load('config/services.yaml');
        $signalService = $container->findDefinition('idoit.flows.signal');

        foreach ($container->findTaggedServiceIds('idoit.flows.signal') as $id => $tags) {
            $reference = new Reference($id);
            foreach ($tags as $tag) {
                $signal = $tag['signal'] ?? null;
                if (!is_string($signal)) {
                    continue;
                }
                $signalService->addMethodCall('add', [$signal, $reference]);
            }
        }
    }
}